using System;
using System.Linq;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        var x = Console.ReadLine().Split().Select(int.Parse).ToArray();
        var h = Console.ReadLine().Split().Select(int.Parse).ToArray();

        int[] result = new int[n];

        for (int i = 0; i < n; i++)
        {
            result[i] = -1;
        }

        for (int i = 0; i < n; i++)
        {
            int minDist = int.MaxValue;

            for (int j = 0; j < n - 1; j++)
            {
                int x1 = x[j];
                int x2 = x[j + 1];
                int h1 = h[j];
                int h2 = h[j + 1];

                if (h1 == h2)
                {
                    if (x[i] >= x1 && x[i] <= x2)
                    {
                        minDist = Math.Min(minDist, Math.Abs(h1 - h[i]));
                    }
                }
                else
                {
                    double slope = (double)(h2 - h1) / (x2 - x1);
                    double intercept = h1 - slope * x1;

                    double yOnRope = slope * x[i] + intercept;

                    if (yOnRope >= h[i])
                    {
                        minDist = Math.Min(minDist, Math.Abs(yOnRope - h[i]));
                    }
                }
            }

            if (minDist != int.MaxValue)
                result[i] = minDist;
        }

        foreach (var res in result)
        {
            Console.WriteLine(res);
        }
    }
}